#define MOZZI_ANALOG_READ_RESOLUTION 10

#include <Mozzi.h>
#include <Oscil.h>
#include <EventDelay.h>
#include <ADSR.h>
#include <tables/sin8192_int8.h>
#include <mozzi_rand.h>
#include <mozzi_midi.h>
#include <Arpeggiator.h>  

#define BUTTON_1 2
#define BUTTON_2 3
#define BUTTON_3 4

unsigned long millis_time;
Arpeggiator arp;
Oscil<MOZZI_AUDIO_RATE / 2, MOZZI_AUDIO_RATE> aOscil(SIN8192_DATA);
ADSR<MOZZI_AUDIO_RATE, MOZZI_AUDIO_RATE> envelope;

boolean note_is_on = true;

unsigned int duration, attack, decay, sustain, release_ms;

int lastCenter = 0;
int lastRange = 0;
int oldTranspose = 0;
int currentNote = 80;  // for pitch modulation

void buttonPressed(int b)
{
  if (b == 1) {
    arp.nextScale();
  }
  if (b == 2) {
    arp.nextDirection();
  }
  if (b == 3) {
    arp.nextNotePattern();
  }
}

void updateControl()
{
  int center = map(mozziAnalogRead(A0), 1023, 0, 40, 100);
  int range = map(mozziAnalogRead(A1), 1023, 0, 3, 40);
  int transpose = map(mozziAnalogRead(A2), 1023, 0, -6, 6);

  if (abs(center - lastCenter) > 3) { 
    arp.setCenter(center);
    arp.setRange(range);
    lastCenter = center;
  }

  if (abs(range - lastRange) > 3) {
    arp.setRange(range);
    lastRange = range;
  }

  if (transpose != oldTranspose) {
    arp.setTranspose(transpose);
    oldTranspose = transpose;
  }

  long bpm = map(mozziAnalogRead(A7), 1023, 0, 20, 150);
  arp.setBpm(bpm);

  // --- New Potentiometer Controls ---
  int attackMs = map(mozziAnalogRead(A4), 0, 1023, 0, 500);
  int releaseMs = map(mozziAnalogRead(A5), 0, 1023, 0, 1000);
  int pitchMod = map(mozziAnalogRead(A6), 0, 1023, -12, 12); // ±1 octave

  envelope.setTimes(attackMs, 150, 0, releaseMs);
  aOscil.setFreq((float)mtof(currentNote + pitchMod));
}

AudioOutput updateAudio()
{
  envelope.update();
  return MonoOutput::from16Bit((int)(envelope.next() * aOscil.next()));
}

int lastButtonValue = 0;
unsigned long lastButtonUpdateTime = 0;

void loop()
{
  millis_time = millis();
  arp.update(millis_time);
  audioHook();

  if (millis_time - lastButtonUpdateTime < 50) {
    return;
  }

  int buttons = (PIND & 0x1C) >> 2; 
  
  if (buttons != lastButtonValue) {
    lastButtonUpdateTime = millis_time;
    lastButtonValue = buttons;
    if (buttons & 0x01) { buttonPressed(1); }
    if (buttons & 0x02) { buttonPressed(2); }
    if (buttons & 0x04) { buttonPressed(3); }
  }
}

void setup()
{
  arp.start();
  arp.setScaleFromIndex(2);

  Serial.begin(115200);
  Serial.println("Starting up...");

  randSeed();
  envelope.setADLevels(180, 90);
  envelope.setTimes(50, 150, 0, 10); // initial values

  aOscil.setFreq((int)mtof(80));  

  arp.setNoteOnCallback([](int note) {
    envelope.noteOn();
    currentNote = note;
    aOscil.setFreq((float)mtof(note));
  });

  startMozzi();

  pinMode(BUTTON_1, INPUT_PULLUP);
  pinMode(BUTTON_2, INPUT_PULLUP);
  pinMode(BUTTON_3, INPUT_PULLUP);
}
