//This is code for ZENITH DIY KIT syntheseizer made by Veerle Pennock - Acid Solder Club 2025
// you can find the build doc for ZENITH on https://acidsolderclub.com/diy-kits/  or www.acidsolderclub.com

// the code is based on an Amen Break/Drumbreak sample, using Mozzi Librairy for Arduino.
// for the code to work, you need to install the librairy. The install instructions can be found on (https://sensorium.github.io/Mozzi/) or find how to install librairy's to the Arduino IDE here: https://docs.arduino.cc/software/ide-v1/tutorials/installing-libraries/
// make sure to install the latest version of Arduino via the website. 

//This example for Zenith V2.0 does not use the external sensor inputs (yet), this will be updated in the upcoming months. You can add the sensor inputs as Analog inputs and they are in the 2.0 version mapped to Analog inputs A4, A5 and A6. 

#define MOZZI_CONTROL_RATE 128
#include <Mozzi.h>
#include <Sample.h>
#include <samples/abomb16384_int8.h>
#include <EventDelay.h>
#include <mozzi_rand.h>

Sample <ABOMB_NUM_CELLS, MOZZI_AUDIO_RATE> aSample(ABOMB_DATA);
EventDelay  kTriggerDelay;

// Default values (change these for more chaos)
float baseSpeed = 1.3;
float playspeedmod = 0;
float speedchange = 0;
float volumeGain = 1.5;  // This is a piece of code for a volume multiplier (1.0 = normal, >1.0 = louder)

void setup(){
  randSeed();
  aSample.setLoopingOn();
  aSample.setFreq(baseSpeed * ((float) ABOMB_SAMPLERATE / (float) ABOMB_NUM_CELLS));
  kTriggerDelay.set(1000);
  startMozzi();
}

void updatePotControls(){
  // Read and map potentiometer values (ZENITH top potentiometers to use are these numbers - 100K)
  int rawBaseSpeed     = analogRead(A0);
  int rawLoopStart     = analogRead(A1);
  int rawLoopEnd       = analogRead(A2);
  int rawSpeedRange    = analogRead(A3);
  int rawTriggerDelay  = analogRead(A7); 


  // Map base playback speed: approx. 0.5x to 2.0x
  baseSpeed = map(rawBaseSpeed, 0, 1023, 50, 200) / 100.0;

  // Map loop range
  unsigned int start = map(rawLoopStart, 0, 1023, 0, ABOMB_NUM_CELLS - 1);
  unsigned int end   = map(rawLoopEnd, 0, 1023, start + 1, ABOMB_NUM_CELLS); // ensure end > start
  aSample.setStart(start);
  aSample.setEnd(end);

  // Speed modulation range
  float modRange = map(rawSpeedRange, 0, 1023, 0, 100) / 1000.0;

  // Occasionally randomize the modulation
  if (rand((byte)3) == 0){
    speedchange = (float)rand((char)-100,(char)100) * modRange / 100.0;
    playspeedmod = baseSpeed + (float)rand((char)-50, (char)50) / 100.0;
  } else {
    speedchange = 0;
    playspeedmod = baseSpeed;
  }

  // Set delay between loop updates
  unsigned int delayMs = map(rawTriggerDelay, 0, 1023, 100, 2000);
  kTriggerDelay.set((int)(delayMs * MOZZI_CONTROL_RATE / 1000));
}

void updateControl(){
  if(kTriggerDelay.ready()){
    updatePotControls();
    kTriggerDelay.start();
  }
  playspeedmod += speedchange;
  aSample.setFreq(playspeedmod * ((float) ABOMB_SAMPLERATE / (float) ABOMB_NUM_CELLS));
}

AudioOutput updateAudio(){
  // Convert 8-bit unsigned (0-255) to signed (-128 to 127) and apply volume gain
  int8_t sample = (int8_t)(aSample.next() - 128);
  int amplified = (int)(sample * volumeGain);
  amplified = constrain(amplified, -128, 127); // Ensure no clipping

  return MonoOutput(amplified);
}

void loop(){
  audioHook();
}
